/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.slabfish.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.minecraftabnormals.environmental.common.slabfish.condition.SlabfishCondition;
import com.minecraftabnormals.environmental.common.slabfish.condition.SlabfishConditionContext;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class SlabfishInBlockCondition
implements SlabfishCondition {
    private final Block block;
    private final ITag<Block> tag;

    private SlabfishInBlockCondition(@Nullable Block block, @Nullable ITag<Block> tag) {
        this.block = block;
        this.tag = tag;
    }

    public static SlabfishCondition deserialize(JsonObject json, JsonDeserializationContext context) {
        if (json.has("block") && json.has("tag")) {
            throw new JsonSyntaxException("Either 'block' or 'tag' can be present.");
        }
        if (!json.has("block") && !json.has("tag")) {
            throw new JsonSyntaxException("Either 'block' or 'tag' must be present.");
        }
        return new SlabfishInBlockCondition(json.has("tag") ? null : (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(json.get("block").getAsString())), json.has("tag") ? TagCollectionManager.func_242178_a().func_241835_a().func_199910_a(new ResourceLocation(json.get("tag").getAsString())) : null);
    }

    @Override
    public boolean test(SlabfishConditionContext context) {
        return this.block != null ? context.isInBlock(this.block) : context.isInBlock(this.tag);
    }
}

